﻿using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Diagnostics;
using VeteransAffairs.Registries.BusinessManagerAHOBPR.Emis;

using VeteransAffairs.Registries.BusinessAHOBPR;
using PS = VeteransAffairs.Registries.BusinessAHOBPR.PaymentService;
using VeteransAffairs.Registries.BusinessManagerAHOBPR;

namespace WCF_BusinessManagerAHOBPRTests.EMIS
{
    [TestClass]
    public class DoDManagerTests
    {
        string con = "Data Source=DNS;Initial Catalog=Registry_AHOBPRHRE;Integrated Security=True;Encrypt=yes;TrustServerCertificate=True";
        [TestMethod]
        public void ProcessDeploymentsAddsNewDeploymentsFromEmis()
        {
             var edipi = "1005136624";
            RegistrantHistory history = CreateRegistrantHistory();
            var cut = new RegistrantDeploymentManager(con);
            var factory = new RegistrantDeploymentFactory(con);

            List<IDeployment> deployments = new DoDDeploymentImporter().GetRegistrantDeployments(history, edipi, factory);

            var actual = cut.ProcessDeployments(deployments, 45725, history);
            Assert.AreEqual(true, actual);
        }

        [TestMethod]
        public void ProcessDeploymentsUpdatesRegistrantEnteredDeployments()
        {
            var edipi = "1005136624";
            
            RegistrantHistory history = CreateRegistrantHistory();
            history.PaymentDataByDateTime = CreatePettyOfficerPayData();

            var cut = new RegistrantDeploymentManager(con);
            var factory = new RegistrantDeploymentFactory(con);

            List<IDeployment> deployments = new DoDDeploymentImporter().GetRegistrantDeployments(history, edipi, factory);
            Trace.WriteLine($"Number of Deployments: {deployments.Count()}\nGoing into Test");

            var actual = cut.ProcessDeployments(deployments, 45725, history);
            Assert.AreEqual(true, actual);
        }

        private static Dictionary<DateTime, PS.PayGradeHistoryData> CreatePettyOfficerPayData()
        {

            return new Dictionary<DateTime, PS.PayGradeHistoryData>
            {
                { DateTime.Parse("2012-05-12"),
                new PS.PayGradeHistoryData
                {
                    payPlanCode = "ME",
                    PayGradeCode = "04",
                    serviceRankNameTxt = "Petty Officer Third Class",
                    serviceRankNameCode = "PO3",
                    payGradeDate = DateTime.Parse("2012-05-12")
                } },

                 { DateTime.Parse("2008-08-15"),
                  new PS.PayGradeHistoryData
                {
                    payPlanCode = "ME",
                    PayGradeCode = "03",
                    serviceRankNameTxt = "Seaman",
                    serviceRankNameCode = "SN",
                    payGradeDate = DateTime.Parse("2008-08-15")
                } },
                   { DateTime.Parse("2002-04-07"),
                new PS.PayGradeHistoryData
                {
                    payPlanCode = "ME",
                    PayGradeCode = "02",
                    serviceRankNameTxt = "Seaman Apprentice",
                    serviceRankNameCode = "SA",
                    payGradeDate = DateTime.Parse("2002-04-07")
                } },
                     { DateTime.Parse("1994-04-07"),
                new PS.PayGradeHistoryData
                {
                    payPlanCode = "ME",
                    PayGradeCode = "02",
                    serviceRankNameTxt = "Seaman Apprentice",
                    serviceRankNameCode = "SA",
                    payGradeDate = DateTime.Parse("1994-04-07")
                } },
            };

        }
        private static RegistrantHistory CreateRegistrantHistory()
        {
            RegistrantHistory history = new RegistrantHistory();
            var personnelCategoryCodes = new Dictionary<DateRange, string>
            {
                { new DateRange(DateTime.Parse("4/7/2002 12:00:00 AM"), DateTime.Parse("11/11/9999 12:00:00 AM")), "V"},
                { new DateRange(DateTime.Parse("4/7/1983 12:00:00 AM"), DateTime.Parse("1/23/1992 12:00:00 AM")), "A"}
            };
            var payPlan = new Dictionary<DateTime, PS.PayGradeHistoryData>
            {
                { DateTime.Parse("2009-11-15"),
                new PS.PayGradeHistoryData
                {
                    payPlanCode = "ME",
                    PayGradeCode = "05",
                    serviceRankNameTxt = "Sergeant",
                    serviceRankNameCode = "SGT",
                    payGradeDate = DateTime.Parse("2009-11-15")
                } }
            };

            var occupations = new SortedDictionary<DateTime, List<ServiceSpecificOccupation>>{
                { DateTime.Parse("3/31/2014 12:00:00 AM"),
                        new List<ServiceSpecificOccupation>{
                                new ServiceSpecificOccupation{OccupationId = 12638, StartDate = DateTime.Parse("3/31/2014 12:00:00 AM"), Type = 'P'}
                               ,new ServiceSpecificOccupation{OccupationId = 12767, StartDate = DateTime.Parse("3/31/2014 12:00:00 AM"), Type = 'S'}
                    }
                },
                 { DateTime.Parse("5/12/2012 12:00:00 AM"),
                        new List<ServiceSpecificOccupation>{
                                new ServiceSpecificOccupation{OccupationId = 1194, StartDate = DateTime.Parse("4/7/1983 12:00:00 AM"), Type = 'P'}
                    }
                },
                 { DateTime.Parse("8/15/2008 12:00:00 AM"),
                        new List<ServiceSpecificOccupation>{
                                new ServiceSpecificOccupation{OccupationId = 1164, StartDate = DateTime.Parse("4/7/1983 12:00:00 AM"), Type = 'P'}
                    }
                },
                 { DateTime.Parse("8/15/2003 12:00:00 AM"),
                        new List<ServiceSpecificOccupation>{
                                new ServiceSpecificOccupation{OccupationId = 1122, StartDate = DateTime.Parse("4/7/1983 12:00:00 AM"), Type = 'D'}
                    }
                },
                 { DateTime.Parse("4/7/1989 12:00:00 AM"),
                        new List<ServiceSpecificOccupation>{
                                new ServiceSpecificOccupation{OccupationId = 8369, StartDate = DateTime.Parse("4/7/1983 12:00:00 AM"), Type = 'D'}
                    }
                },
                { DateTime.Parse("4/7/1983 12:00:00 AM"),
                        new List<ServiceSpecificOccupation>{
                                new ServiceSpecificOccupation{OccupationId = 2834, StartDate = DateTime.Parse("4/7/1983 12:00:00 AM"), Type = 'P'}
                    }
                }
            };
            //var svcEpisodeStart = DateTime.Parse("2010-08-20");
            //var svcEpisodeEnd = DateTime.Parse("2015-08-13");
            //  var svcDateRange = new DateRange(svcEpisodeStart, svcEpisodeEnd);
            Dictionary<DateRange, string> svcEpisodes = new Dictionary<DateRange, string>
                      {
                        {new DateRange(DateTime.Parse("4/7/2002"), DateTime.Parse("11/11/9999")), "N"},
                        {new DateRange(DateTime.Parse("1/26/1992"), DateTime.Parse("1/23/2001")), "N"},
                        {new DateRange(DateTime.Parse("4/7/1983"), DateTime.Parse("1/23/1992")), "N"}
                      };
            history.BranchesOfService = svcEpisodes;
            history.OccupationsByDateTime = occupations;
            history.PaymentDataByDateTime = payPlan;
            history.PersonnelCategoryCodesByDateRange = personnelCategoryCodes;
            return history;
        }

        /// <summary>
        /// Helper method to use Emis to generate test data
        /// </summary>
        /// <param name="branchesOfService"></param>
        //private void WriteBranchesOfService(Dictionary<DateRange, string> branchesOfService)
        //{
        //    if (branchesOfService == null) throw new ArgumentNullException(nameof(branchesOfService));
        //    Console.WriteLine("new Dictionary<DateRange, string>{");
        //    foreach (KeyValuePair<DateRange, string> kvp in branchesOfService)
        //    {
        //        Console.Write($"{{new DateRange(DateTime.Parse(\"{kvp.Key.Start.ToShortDateString()}\")), ");
        //        Console.WriteLine($"DateTime.Parse(\"{ kvp.Key.End.ToShortDateString()}\"), \"{kvp.Value}\"}},");
        //    }
        //    Console.WriteLine("};");
        //}
    }
}
